/*** input-tcpudp.h -- TCP/UDP Input Source
 *
 * Copyright (C) 2006, 2007, 2008 Sebastian Freundt
 *
 * Author:  Sebastian Freundt <hroptatyr@sxemacs.org>
 *
 * This file is part of SXEmacs.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the author nor the names of any contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***/

#ifndef INCLUDED_input_tcpudp_h
#define INCLUDED_input_tcpudp_h

#include <kant/kant.h>
#include "inputs.h"

#define INPUT_DEBUG_TCPUDP(args...)	INPUT_DEBUG("[tcpudp] " args)
#define INPUT_CRITICAL_TCPUDP(args...)	INPUT_CRITICAL("[tcpudp] " args)

/* port proposal 5274 which is vanity for KASH,
 * however me thinks we ought to listen to something+uid() since kash
 * isnt (yet) a site-wide thing */
#define TCPUDP_DEFAULT_PORT	5274	/* vanity for KASH */

#define TCPUDP_CLI_COOKIE	"AK3CLIP0"
#define TCPUDP_SRV_COOKIE	"AK3SRVP0"
#define TCPUDP_COOKIE_SIZE	8
#if SIZEOF_VOID_P == 4
#define TCPUDP_BLSZ		"4444"
#elif SIZEOF_VOID_P == 8
#define TCPUDP_BLSZ		"8888"
#else
#  error "Seriously, you are on the l4mest arse system on earth!"
#endif
#define TCPUDP_BLSZ_SIZE	4
#define TCPUDP_OPTS_SIZE	12

#define TCPUDP_HEADER_SIZE		\
	TCPUDP_COOKIE_SIZE +		\
	TCPUDP_BLSZ_SIZE +		\
	TCPUDP_OPTS_SIZE +		\
	SIZEOF_VOID_P

typedef struct tcpudp_data_s *tcpudp_data_t;
typedef struct tcpudp_ctx_s *tcpudp_ctx_t;
typedef struct tcpudp_ctxset_s *tcpudp_ctxset_t;

extern input_ctx_t make_input_tcpudp(void);
extern void free_input_tcpudp(input_ctx_t);

/* for the sake of fuck^Wcommand line */
extern char *listen_spec_default;
extern void tcp4_listen_spec(char *hostport);
extern void tcp6_listen_spec(char *hostport);
extern void unix_listen_spec(char *path);


extern void init_input_tcpudp(void);
extern void reinit_input_tcpudp(void);
extern void deinit_input_tcpudp(void);

#endif	/* INCLUDED_input_tcpudp_h */
