/*** kash-system.h -- System abstraction functions
 *
 * Copyright (C) 2006, 2007, 2008 Sebastian Freundt
 * Copyright (C) 1993 RWTH Aachen
 *
 * Author:  Sebastian Freundt <hroptatyr@sxemacs.org>
 * Author:  Martin Schoenert
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the author nor the names of any contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ** Commentary:
 *
 * System abstraction -- the modern version.
 *
 ***/

#ifndef INCLUDED_kash_system_h
#define INCLUDED_kash_system_h

#include "config.h"

#ifdef HAVE_STDIO_H
#  include <stdio.h>
#endif
#ifdef STDC_HEADERS
#  include <stdlib.h>
#  include <stddef.h>
#elif defined(HAVE_STDLIB_H)
#  include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#  if !defined STDC_HEADERS && defined HAVE_MEMORY_H
#    include <memory.h>
#  endif
#  include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#  include <strings.h>
#endif
#ifdef HAVE_INTTYPES_H
#  include <inttypes.h>
#endif
#ifdef HAVE_STDINT_H
#  include <stdint.h>
#endif
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#ifdef HAVE_CTYPE_H
#  include <ctype.h>
#endif
#ifdef HAVE_WCHAR_H
#  include <wchar.h>
#endif

/* hooks */
extern void handle_sigint_hook(void) __attribute__((weak));
extern void handle_sigpipe_hook(void) __attribute__((weak));

/* wrapper around exit() */
extern void xexit(long ret) __attribute__((noreturn));

#if !defined HAVE_DECL_STRNCAT
extern char *strncat(char *, const char *, size_t);
#endif	/* !HAVE_DECL_STRNCAT */
#if !defined HAVE_DECL_STRCMP
extern int strcmp(const char *, const char *);
#endif	/* !HAVE_DECL_STRCMP */
#if !defined HAVE_DECL_STRLEN
extern size_t strlen(const char *);
#endif	/* !HAVE_DECL_STRLEN */

#ifdef HAVE_MEMCMP
#define xmemcmp		memcmp
#endif

/* always assume a gnu compiler and use c89 inlines */
#undef extern_inline
#define extern_inline	extern inline __attribute__((always_inline, gnu_inline))


extern void init_kash_system(void);
extern void reinit_kash_system(void);
extern void deinit_kash_system(void);

#endif	/* INCLUDED_kash_system_h */
