/*** kash.h -- Global definitions
 *
 * Copyright (C) 2006, 2007, 2008 Sebastian Freundt
 *
 * Author:  Sebastian Freundt <hroptatyr@sxemacs.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the author nor the names of any contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***/

#ifndef INCLUDED_kash_h
#define INCLUDED_kash_h

#include <kant/kant.h>

/* system dependent functions */
#include "kash-system.h"
#include "kash-globvars.h"

/* evaluator main dispatcher */
#include "kash-eval.h"

#ifdef ALL_DEBUG_FLAGS
#undef KASH_DEBUG_FLAG
#define KASH_DEBUG_FLAG			1
#endif

#define __KASH_DEBUG__(args...)		fprintf(stderr, "KASH " args)
#define __KASHD_DEBUG__(args...)	fprintf(stderr, "KASHD " args)
#define __KASHC_DEBUG__(args...)	fprintf(stderr, "KASHC " args)
#ifdef KASH_DEBUG_FLAG
#define KASH_DEBUG(args...)		__KASH_DEBUG__(args)
#define KASHD_DEBUG(args...)		__KASHD_DEBUG__(args)
#define KASHC_DEBUG(args...)		__KASHC_DEBUG__(args)
#else
#define KASH_DEBUG(args...)
#define KASHD_DEBUG(args...)
#define KASHC_DEBUG(args...)
#endif
#define KASH_DEBUG_KERNEL(args...)	KASH_DEBUG("[kernel]: " args)
#define KASH_DEBUG_CORE(args...)	KASH_DEBUG_KERNEL(args)
#define KASH_DEBUG_WORKER(args...)	KASH_DEBUG("[worker]: " args)
#define KASH_DEBUG_SCRATCH(args...)	KASH_DEBUG("[scratch]: " args)
#define KASH_CRITICAL(args...)		__KASH_DEBUG__("CRITICAL: " args)
#define KASHD_CRITICAL(args...)		__KASHD_DEBUG__("CRITICAL: " args)
#define KASHD_INFO(args...)		__KASHD_DEBUG__("INFO: " args)
#define KASHC_CRITICAL(args...)		__KASHC_DEBUG__("CRITICAL: " args)
#define KASHC_INFO(args...)		__KASHC_DEBUG__("INFO: " args)

/* C99 inlines */
extern_inline handle_t
FunIgnore(handle_t hdCall)
	__attribute__((always_inline));


#endif	/* INCLUDED_kash_h */
