/*** lang-kant.c -- internal language, binary
 * Copyright (C) 2006, 2007, 2008 Sebastian Freundt
 *
 * Author:  Sebastian Freundt <freundt@math.tu-berlin.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the author nor the names of any contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***/

#ifndef INCLUDED_lang_kant_h
#define INCLUDED_lang_kant_h

#include "config.h"
#include "langs.h"

/**
 * \defgroup lang_kant The KANT marshalling language
 * \ingroup langs
 *
 * \brief A marshalling proof-of-concept
 *
 * \{
 */

#define LANG_DEBUG_KANT(args...)	LANG_DEBUG("[kant] " args)

extern_inline void step_kant_packet(lang_ctx_t ctx);
extern_inline void step_kant_bucket(lang_ctx_t ctx, size_t size);


extern lnghdl_dispatch_f
defkant_dispatch_f(long unsigned int type, lnghdl_dispatch_f);
extern lnghdl_read_f
defkant_read_f(void *data, lnghdl_read_f);
extern lnghdl_resultify_f
defkant_resultify_f(long unsigned int type, lnghdl_resultify_f);

extern int kant_lang_stream(lang_ctx_t ctx, handle_t hd);
extern void *lang_kant_dispatch(lang_ctx_t, handle_t);
extern handle_t lang_kant_read(lang_ctx_t);
extern int lang_kant_resultify(lang_ctx_t, handle_t);

extern void init_lang_kant(void);
extern void reinit_lang_kant(void);
extern void deinit_lang_kant(void);


/* inlines */
extern_inline void
step_kant_packet(lang_ctx_t ctx)
{
	ctx->offset += SIZE_LANG_STREAM_S;
	ctx->curbuf += SIZE_LANG_STREAM_S;
}

extern_inline void
step_kant_bucket(lang_ctx_t ctx, size_t size)
{
	ctx->offset += size;
	ctx->curbuf += size;
}

/**
 * \} */

#endif	/* INCLUDED_lang_kant_h */
